#version 110

uniform sampler2D tex;
varying vec2 tex_coord;

uniform float max_opacity;
uniform float flashlight_radius;
uniform vec2 flashlight_center;

void main(void)
{
    float dist = distance(flashlight_center, gl_FragCoord.xy);
    float opacity = 1.0 - smoothstep(flashlight_radius, flashlight_radius * 1.4, dist);
    opacity = min(opacity, max_opacity);

    vec4 color = texture2D(tex, tex_coord);
    color.a = opacity;

    gl_FragColor = color;
}
